/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanWithAnnotationInheritedTest
extends ContextTestSupport {
    @Test
    public void testWithAnnotationsFromOneInterface() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"x1y1"});
        this.template.requestBody("direct:in1", (Object)"whatever");
        mock.assertIsSatisfied();
    }

    @Test
    public void testWithAnnotationsFromTwoInterfaces() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"x2y2"});
        this.template.requestBody("direct:in2", (Object)"whatever");
        mock.assertIsSatisfied();
    }

    @Test
    public void testWithAnnotationsFromSuperclassAndInterface() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"x3y3"});
        this.template.requestBody("direct:in3", (Object)"whatever");
        mock.assertIsSatisfied();
    }

    @Test
    public void testWithAnnotationsFromImplementationClassAndInterface() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"x4y4"});
        this.template.requestBody("direct:in4", (Object)"whatever");
        mock.assertIsSatisfied();
    }

    @Test
    public void testWithAnnotationsFromOneInterfaceInheritedByProxy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"x5y5"});
        this.template.requestBody("direct:in5", (Object)"whatever");
        mock.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("b", (Object)new B());
        answer.bind("p", Proxy.newProxyInstance(I1.class.getClassLoader(), new Class[]{I1.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (method.getName().equals("m1")) {
                    return args[0].toString() + args[1].toString();
                }
                return null;
            }
        }));
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:in1").setHeader("foo", (Expression)this.constant("x1"))).setHeader("bar", (Expression)this.constant("y1"))).to("bean:b?method=m1")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:in2").setHeader("foo", (Expression)this.constant("x2"))).setHeader("bar", (Expression)this.constant("y2"))).to("bean:b?method=m2")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:in3").setHeader("foo", (Expression)this.constant("x3"))).setHeader("bar", (Expression)this.constant("y3"))).to("bean:b?method=m3")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:in4").setHeader("foo", (Expression)this.constant("x4"))).setHeader("bar", (Expression)this.constant("y4"))).to("bean:b?method=m4")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:in5").setHeader("foo", (Expression)this.constant("x5"))).setHeader("bar", (Expression)this.constant("y5"))).to("bean:p?method=m1")).to("mock:result");
            }
        };
    }

    private static class B
    extends A
    implements I1 {
        private B() {
        }

        @Override
        public String m1(String h1, String h2) {
            return h1 + h2;
        }

        @Override
        public String m2(String h1, String h2) {
            return h1 + h2;
        }

        @Override
        public String m4(String h1, @Header(value="bar") String h2) {
            return h1 + h2;
        }
    }

    private static interface I1 {
        public String m1(@Header(value="foo") String var1, @Header(value="bar") String var2);

        public String m2(@Header(value="foo") String var1, String var2);
    }

    private static abstract class A
    implements I2 {
        private A() {
        }

        @Override
        public String m3(String h1, @Header(value="bar") String h2) {
            return h1 + h2;
        }
    }

    private static interface I2 {
        public String m2(String var1, @Header(value="bar") String var2);

        public String m3(@Header(value="foo") String var1, String var2);

        public String m4(@Header(value="foo") String var1, String var2);
    }
}

