/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanWithAnnotationAndExchangeTest
extends ContextTestSupport {
    @Test
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"StartMyBean"});
        mock.expectedHeaderReceived("user", (Object)"admin");
        this.template.requestBody("direct:in", (Object)"Start");
        mock.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").setHeader("user", (Expression)this.constant("admin"))).to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void doSomething(@Header(value="user") String user, @Body String body, Exchange exchange) {
            Assertions.assertEquals((Object)"admin", (Object)user);
            exchange.getIn().setBody((Object)(body + "MyBean"));
        }
    }
}

