/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanThrowAssertionErrorTest
extends ContextTestSupport {
    @Test
    public void testAssertion() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should fail");
    }

    @Test
    public void testAssertionProcessor() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start2", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start2", (Object)"Hello Camel"), (String)"Should fail");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean((Object)BeanThrowAssertionErrorTest.this, "doSomething")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").bean((Object)new MyProcessorBean())).to("mock:result");
            }
        };
    }

    public void doSomething(String body) {
        Assertions.assertEquals((Object)"Hello Camel", (Object)body);
    }

    private static class MyProcessorBean
    implements Processor {
        private MyProcessorBean() {
        }

        public void process(Exchange exchange) {
            Assertions.assertEquals((Object)"Hello World", (Object)exchange.getMessage().getBody());
        }
    }
}

