/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanReturnNullTest
extends ContextTestSupport {
    @Test
    public void testReturnBean() {
        MyBean out = (MyBean)this.template.requestBody("direct:start", (Object)"Camel", MyBean.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Camel", (Object)out.getName());
    }

    @Test
    public void testReturnNull() {
        Object out = this.template.requestBody("direct:start", (Object)"foo");
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testReturnNullMyBean() {
        MyBean out = (MyBean)this.template.requestBody("direct:start", (Object)"foo", MyBean.class);
        Assertions.assertNull((Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").bean(BeanReturnNullTest.class, "doSomething");
            }
        };
    }

    public MyBean doSomething(String body) {
        if ("foo".equals(body)) {
            return null;
        }
        return new MyBean(body);
    }

    public static final class MyBean {
        public final String name;

        public MyBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

