/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.Callable;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanReturnCallableTest
extends ContextTestSupport {
    @Test
    public void testBeanReturnCallable() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"I was called"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        this.template.requestBody("direct:in", (Object)"Start");
        mock.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").setHeader("foo", (Expression)this.constant("bar"))).to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public Callable<String> doSomething() {
            return () -> "I was called";
        }
    }
}

