/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanRefMethodNotFoundTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testBeanRefMethodNotFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").routeId("a").bean((Object)"foo", "hello")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").routeId("b").bean((Object)"foo", "bye")).to("mock:b");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        FailedToCreateRouteException failed = BeanRefMethodNotFoundTest.assertIsInstanceOf(FailedToCreateRouteException.class, e);
        Assertions.assertEquals((Object)"b", (Object)failed.getRouteId());
        MethodNotFoundException cause = BeanRefMethodNotFoundTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"bye", (Object)cause.getMethodName());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

