/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ProxyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.OrderService;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class BeanProxyTest
extends ContextTestSupport {
    @Test
    public void testBeanProxyStringReturnString() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        String reply = service.submitOrderStringReturnString("<order type=\"book\">Camel in action</order>");
        Assertions.assertEquals((Object)"<order id=\"123\">OK</order>", (Object)reply);
    }

    @Test
    public void testBeanProxyStringReturnDocument() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        Document reply = service.submitOrderStringReturnDocument("<order type=\"book\">Camel in action</order>");
        Assertions.assertNotNull((Object)reply);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)reply);
        Assertions.assertEquals((Object)"<order id=\"123\">OK</order>", (Object)s);
    }

    @Test
    public void testBeanProxyDocumentReturnString() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<order type=\"book\">Camel in action</order>");
        String reply = service.submitOrderDocumentReturnString(doc);
        Assertions.assertEquals((Object)"<order id=\"123\">OK</order>", (Object)reply);
    }

    @Test
    public void testBeanProxyDocumentReturnDocument() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<order type=\"book\">Camel in action</order>");
        Document reply = service.submitOrderDocumentReturnDocument(doc);
        Assertions.assertNotNull((Object)reply);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)reply);
        Assertions.assertEquals((Object)"<order id=\"123\">OK</order>", (Object)s);
    }

    @Test
    public void testBeanProxyFailure() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        String reply = service.submitOrderStringReturnString("<order type=\"beer\">Carlsberg</order>");
        Assertions.assertEquals((Object)"<order>FAIL</order>", (Object)reply);
    }

    @Test
    public void testBeanProxyFailureNotXMLBody() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        Assertions.assertThrows(Exception.class, () -> service.submitOrderStringReturnString("Hello World"), (String)"Should have thrown exception");
    }

    @Test
    public void testBeanProxyVoidReturnType() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        service.doNothing("<order>ping</order>");
    }

    @Test
    public void testBeanProxyFailureInvalidReturnType() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:start");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> service.invalidReturnType("<order type=\"beer\">Carlsberg</order>"), (String)"Should have thrown exception");
        InvalidPayloadException cause = BeanProxyTest.assertIsInstanceOf(InvalidPayloadException.class, e.getCause());
        Assertions.assertEquals(Integer.class, (Object)cause.getType());
    }

    @Test
    public void testBeanProxyCallAnotherBean() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:bean");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        String reply = service.submitOrderStringReturnString("World");
        Assertions.assertEquals((Object)"Hello World", (Object)reply);
    }

    @Test
    public void testProxyBuilderProxyCallAnotherBean() throws Exception {
        OrderService service = (OrderService)new ProxyBuilder((CamelContext)this.context).endpoint("direct:bean").build(OrderService.class);
        String reply = service.submitOrderStringReturnString("World");
        Assertions.assertEquals((Object)"Hello World", (Object)reply);
    }

    @Test
    public void testBeanProxyCallAnotherBeanWithNoArgs() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:bean");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        String reply = service.doAbsolutelyNothing();
        Assertions.assertEquals((Object)"Hi nobody", (Object)reply);
    }

    @Test
    public void testProxyBuilderProxyCallAnotherBeanWithNoArgs() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:bean");
        OrderService service = (OrderService)new ProxyBuilder((CamelContext)this.context).endpoint(endpoint).build(OrderService.class);
        String reply = service.doAbsolutelyNothing();
        Assertions.assertEquals((Object)"Hi nobody", (Object)reply);
    }

    @Test
    public void testBeanProxyVoidAsInOut() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("seda:delay");
        OrderService service = (OrderService)ProxyHelper.createProxy((Endpoint)endpoint, OrderService.class);
        this.getMockEndpoint("mock:delay").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        service.doNothing("Hello World");
        this.template.sendBody("mock:delay", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testProxyBuilderVoidAsInOut() throws Exception {
        OrderService service = (OrderService)new ProxyBuilder((CamelContext)this.context).endpoint("seda:delay").build(OrderService.class);
        this.getMockEndpoint("mock:delay").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        service.doNothing("Hello World");
        this.template.sendBody("mock:delay", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.xpath("/order/@type = 'book'")).to("direct:book")).otherwise().to("direct:other")).end();
                this.from("direct:book").transform((Expression)this.constant("<order id=\"123\">OK</order>"));
                this.from("direct:other").transform((Expression)this.constant("<order>FAIL</order>"));
                this.from("direct:bean").bean(MyFooBean.class, "hello");
                this.from("seda:delay").delay(1000L).to("mock:delay");
            }
        };
    }

    public static class MyFooBean {
        public String hello(String name) {
            if (name != null) {
                return "Hello " + name;
            }
            return "Hi nobody";
        }
    }
}

