/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanPropertiesFunctionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("fooBean", (Object)new FooBean());
        registry.bind("barBean", (Object)new BarBean());
        return registry;
    }

    @Test
    public void testParseEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:{{bean:fooBean.foo}}").to("mock:{{bean:barBean.bar}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public static class FooBean {
        public String foo() {
            return "foo";
        }
    }

    public static class BarBean {
        public String bar() {
            return "bar";
        }
    }
}

