/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPropagateHeaderTest
extends ContextTestSupport {
    @Test
    public void testBeanInOnlyPropagateHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Order OK for id: 123"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        String out = (String)this.template.requestBody("direct:start", (Object)"123", String.class);
        Assertions.assertEquals((Object)"OK", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("order", (Object)new MyOrderService());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("bar"))).convertBodyTo(Integer.class)).to("bean:order")).to(ExchangePattern.InOnly, "seda:foo")).transform((Expression)this.constant("OK"));
                this.from("seda:foo").to("mock:result");
            }
        };
    }

    public static class MyOrderService {
        public String confirmOrder(int id) {
            return "Order OK for id: " + id;
        }
    }
}

