/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.PrivateClasses;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public final class BeanPrivateClassWithInterfaceMethodTest
extends ContextTestSupport {
    private static final String INPUT_BODY = "Whatever";
    private final PrivateClasses.HelloCamel packagePrivateImpl = PrivateClasses.newPackagePrivateHelloCamel();
    private final PrivateClasses.HelloCamel privateImpl = PrivateClasses.newPrivateHelloCamel();

    @Test
    public void testPackagePrivateClassBinding() throws InterruptedException {
        MockEndpoint mockResult = this.getMockEndpoint("mock:packagePrivateClassResult");
        mockResult.setExpectedMessageCount(1);
        ((MockValueBuilder)mockResult.message(0).body()).isEqualTo((Object)"Hello Camel");
        this.template.sendBody("direct:testPackagePrivateClass", (Object)INPUT_BODY);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPrivateClassBinding() throws InterruptedException {
        MockEndpoint mockResult = this.getMockEndpoint("mock:privateClassResult");
        mockResult.setExpectedMessageCount(1);
        ((MockValueBuilder)mockResult.message(0).body()).isEqualTo((Object)"Hello Camel");
        this.template.sendBody("direct:testPrivateClass", (Object)INPUT_BODY);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:testPackagePrivateClass").bean((Object)BeanPrivateClassWithInterfaceMethodTest.this.packagePrivateImpl, "sayHello")).to("mock:packagePrivateClassResult");
                ((RouteDefinition)this.from("direct:testPrivateClass").bean((Object)BeanPrivateClassWithInterfaceMethodTest.this.privateImpl, "sayHello")).to("mock:privateClassResult");
            }
        };
    }
}

