/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPipelineTest
extends ContextTestSupport {
    @Test
    public void testBeanInPipeline() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World from James"});
        mock.expectedHeaderReceived("from", (Object)"James");
        this.template.sendBodyAndHeader("direct:input", (Object)"Hello World", "from", (Object)"Claus");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:input").pipeline(new String[]{"bean:foo", "bean:bar?method=usingExchange", "bean:baz"})).to("mock:result");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)new FooBean());
        answer.bind("bar", (Object)new BarBean());
        answer.bind("baz", (Object)new BazBean());
        return answer;
    }

    public static class FooBean {
        public void onlyPlainBody(Object body) {
            Assertions.assertEquals((Object)"Hello World", (Object)body);
        }
    }

    public static class BarBean {
        public void doNotUseMe(String body) {
            Assertions.fail((String)"Should not invoce me");
        }

        public void usingExchange(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            Assertions.assertEquals((Object)"Claus", (Object)exchange.getIn().getHeader("from"));
            exchange.getMessage().setHeader("from", (Object)"James");
            exchange.getMessage().setBody((Object)"Hello World from James");
        }
    }

    public static class BazBean {
        public void doNotUseMe(String body) {
            Assertions.fail((String)"Should not invoce me");
        }

        public void withAnnotations(@Headers Map<String, Object> headers, @Body String body) {
            Assertions.assertEquals((Object)"Hello World from James", (Object)body);
            Assertions.assertEquals((Object)"James", (Object)headers.get("from"));
        }
    }
}

