/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPerformanceTest
extends ContextTestSupport {
    private static final AtomicLong INVOKED = new AtomicLong();

    public static void doSomething(String payload) {
        Assertions.assertEquals((Object)"Hello World", (Object)payload);
        INVOKED.incrementAndGet();
    }

    @Test
    public void testBeanPerformance() {
        StopWatch watch = new StopWatch();
        int times = 100000;
        this.log.info("Invoking a bean in a route {} times", (Object)times);
        for (int i = 0; i < times; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        this.log.info("Took {} to invoke the bean {} times", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true), (Object)times);
        Assertions.assertEquals((long)times, (long)INVOKED.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").bean(BeanPerformanceTest.class, "doSomething");
            }
        };
    }
}

