/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanParameterValueTest
extends ContextTestSupport {
    @Test
    public void testBeanParameterValueBoolean() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueBoolean2() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start2", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueBoolean3() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start3", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueBoolean4() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("direct:start4", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueInteger() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"WorldWorldWorld"});
        this.template.sendBody("direct:echo", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueHeaderInteger() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"WorldWorld"});
        this.template.sendBodyAndHeader("direct:echo2", (Object)"World", "times", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueMap() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:heads", (Object)"World", "hello", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterNoBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Is Hadrian 21 years old?"});
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("SomeTest", true);
        headers.put("SomeAge", 21);
        headers.put("SomeName", "Hadrian");
        this.template.sendBodyAndHeaders("direct:nobody", null, headers);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:foo?method=bar(*,true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("bean:foo?method=bar(${body},true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start3").to("bean:foo?method=bar(${body}, true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start4").to("bean:foo?method=bar('Camel', true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:echo").to("bean:foo?method=echo(*, 3)")).to("mock:result");
                ((RouteDefinition)this.from("direct:echo2").to("bean:foo?method=echo(*, ${in.header.times})")).to("mock:result");
                ((RouteDefinition)this.from("direct:heads").to("bean:foo?method=heads(${body}, ${headers})")).to("mock:result");
                ((RouteDefinition)this.from("direct:nobody").to("bean:foo?method=nobody(${header.SomeAge}, ${header.SomeName}, ${header.SomeTest})")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String bar(String body, boolean hello) {
            if (hello) {
                return "Hello " + body;
            }
            return body;
        }

        public String echo(String body, int times) {
            if (times > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < times; ++i) {
                    sb.append(body);
                }
                return sb.toString();
            }
            return body;
        }

        public String heads(String body, Map<?, ?> headers) {
            return String.valueOf(headers.get("hello")) + " " + body;
        }

        public String nobody(int age, String name, boolean question) {
            StringBuilder sb = new StringBuilder();
            sb.append(question ? "Is " : "");
            sb.append(name);
            sb.append(question ? " " : "is ");
            sb.append(age);
            sb.append(" years old");
            sb.append(question ? "?" : ".");
            return sb.toString();
        }
    }
}

