/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanParameterValueOgnlTest
extends ContextTestSupport {
    @Test
    public void testBeanParameterValue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueBodyOgnl() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Tony"});
        Animal tiger = new Animal("Tony", 13);
        this.template.sendBody("direct:start2", (Object)tiger);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterValueHeaderOgnl() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Kong"});
        Animal kong = new Animal("Kong", 34);
        Animal tiger = new Animal("Tony", 13);
        tiger.setFriend(kong);
        this.template.sendBodyAndHeader("direct:start3", (Object)"Hello World", "animal", (Object)tiger);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:foo?method=bar(${body},true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("bean:foo?method=bar(${body.name}, true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:start3").to("bean:foo?method=bar(${header.animal?.friend.name}, true)")).to("mock:result");
            }
        };
    }

    public static final class Animal {
        private final String name;
        private final int age;
        private Animal friend;

        private Animal(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public Animal getFriend() {
            return this.friend;
        }

        public void setFriend(Animal friend) {
            this.friend = friend;
        }

        public boolean isDangerous() {
            return this.name.contains("Tiger");
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MyBean {
        public String bar(String body, boolean hello) {
            if (hello) {
                return "Hello " + body;
            }
            return body;
        }

        public String echo(String body, int times) {
            if (times > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < times; ++i) {
                    sb.append(body);
                }
                return sb.toString();
            }
            return body;
        }
    }
}

