/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanParameterNoBeanBindingTest
extends ContextTestSupport {
    @Test
    public void testBeanParameterInvalidValueA() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:a", (Object)"World"), (String)"Should have thrown exception");
        RuntimeExchangeException cause = BeanParameterNoBeanBindingTest.assertIsInstanceOf(RuntimeExchangeException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().contains("echo(java.lang.String,int)"));
        Assertions.assertTrue((boolean)cause.getMessage().contains("[World, null]"));
        BeanParameterNoBeanBindingTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").to("bean:foo?method=echo")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String echo(String body, int times) {
            if (body == null) {
                return "";
            }
            if (times > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < times; ++i) {
                    sb.append(body);
                }
                return sb.toString();
            }
            return body;
        }
    }
}

