/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanParameterMethodCallThreeBodyOgnlTest
extends ContextTestSupport {
    @Test
    public void testBeanParameterValue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"3"});
        ArrayList<String> body = new ArrayList<String>();
        body.add("A");
        body.add("B");
        body.add("C");
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("router", (Object)new MyRouter());
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DynamicRouterDefinition)this.from("direct:start").dynamicRouter().method("router")).to("mock:result");
            }
        };
    }

    public static class MyRouter {
        public String route(Object body) {
            if (body instanceof List) {
                return "bean:foo?method=bar('A','B','C')";
            }
            return null;
        }
    }

    public static class MyBean {
        public String bar(String order1, String order2, String order3) {
            Assertions.assertEquals((Object)"A", (Object)order1);
            Assertions.assertEquals((Object)"B", (Object)order2);
            Assertions.assertEquals((Object)"C", (Object)order3);
            return "3";
        }

        public String bar(String order1, String order2) {
            Assertions.assertEquals((Object)"A", (Object)order1);
            Assertions.assertEquals((Object)"B", (Object)order2);
            return "2";
        }

        public String bar(String order1) {
            Assertions.assertEquals((Object)"A", (Object)order1);
            return "1";
        }
    }
}

