/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanParameterInvalidValueTest
extends ContextTestSupport {
    @Test
    public void testBeanParameterInvalidValueA() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:a", (Object)"World"), (String)"Should have thrown exception");
        TypeConversionException cause = BeanParameterInvalidValueTest.assertIsInstanceOf(TypeConversionException.class, e.getCause().getCause());
        Assertions.assertEquals(String.class, (Object)cause.getFromType());
        Assertions.assertEquals(Integer.TYPE, (Object)cause.getToType());
        Assertions.assertEquals((Object)"A", (Object)cause.getValue());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterInvalidValueB() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:b", (Object)"World"), (String)"Should have thrown exception");
        TypeConversionException cause = BeanParameterInvalidValueTest.assertIsInstanceOf(TypeConversionException.class, e.getCause().getCause());
        Assertions.assertEquals(String.class, (Object)cause.getFromType());
        Assertions.assertEquals(Integer.TYPE, (Object)cause.getToType());
        Assertions.assertEquals((Object)"true", (Object)cause.getValue());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterNullC() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:c", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanParameterInvalidValueD() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:d", (Object)"World"), (String)"Should have thrown exception");
        ExpressionEvaluationException cause = BeanParameterInvalidValueTest.assertIsInstanceOf(ExpressionEvaluationException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getCause().getMessage().startsWith("Unknown function: xxx at location 0"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").to("bean:foo?method=echo(*, 'A')")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").to("bean:foo?method=echo(*, true)")).to("mock:result");
                ((RouteDefinition)this.from("direct:c").to("bean:foo?method=echo(null, 2)")).to("mock:result");
                ((RouteDefinition)this.from("direct:d").to("bean:foo?method=echo(${xxx}, 2)")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String echo(String body, int times) {
            if (body == null) {
                return "";
            }
            if (times > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < times; ++i) {
                    sb.append(body);
                }
                return sb.toString();
            }
            return body;
        }

        public String heads(String body, Map<?, ?> headers) {
            return String.valueOf(headers.get("hello")) + " " + body;
        }
    }
}

