/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class BeanPackageScopeTest
extends ContextTestSupport {
    @Test
    public void testPackageScope() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.requestBody("direct:in", (Object)"World");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.bindToRegistry("myBean", new MyBean());
                ((RouteDefinition)this.from("direct:in").to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        String doSomething(String body) {
            return "Hello " + body;
        }

        private String doSomethingElse(String foo) {
            return "foo";
        }
    }
}

