/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanOverloadedMethodTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testHelloOverloadedString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedStringString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String.class, String.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedWildcardString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*, String.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedWildcardWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*,*)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedPickCamelAnnotated() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedAmbiguousStringStringString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String.class,String.class,String.class)")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark"), (String)"Should have thrown an exception");
        AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
        Assertions.assertEquals((int)2, (int)cause.getMethods().size());
    }

    @Test
    public void testHelloOverloadedStringInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String.class,int.class)")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark"), (String)"Should have thrown an exception");
        AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
        Assertions.assertEquals((int)2, (int)cause.getMethods().size());
    }

    @Test
    public void testHelloOverloadedIntString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(int.class,String.class)")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark"), (String)"Should have thrown an exception");
        AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
        Assertions.assertEquals((int)2, (int)cause.getMethods().size());
    }

    @Test
    public void testTimesOverloadedStringInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(String.class,int.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAA"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimesOverloadedBytesInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(byte[].class,int.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC,ABC,ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"ABC".getBytes(), "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPropertyPlaceholder() throws Exception {
        this.context.getPropertiesComponent().addInitialProperty("myDestination", "Mars");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "sendMsg(String.class ${body}, String.class {{myDestination}})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Sending rockets to Mars"});
        this.template.sendBody("direct:start", (Object)"rockets");
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyBean {
        public String hello(String name) {
            return "Hello " + name;
        }

        public String hello(String name, @Header(value="country") String country) {
            return "Hello " + name + " you are from " + country;
        }

        public String times(String name, @Header(value="times") int times) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
            }
            return sb.toString();
        }

        public String times(byte[] data, @Header(value="times") int times) {
            String s = new String(data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(s);
                if (i >= times - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public String times(String name, int times, char separator) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
                if (i >= times - 1) continue;
                sb.append(separator);
            }
            return sb.toString();
        }

        public String sendMsg(String message, String destination) {
            return "Sending " + message + " to " + destination;
        }
    }
}

