/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class BeanOverloadedMethodParameterValueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testHelloOverloadedString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(${body})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedStringString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(${body}, ${header.country})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHelloOverloadedWildcardString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*, ${header.country})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimesOverloadedStringInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(${body},3)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAA"});
        this.template.sendBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimesOverloadedStringIntHeader() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(${body},${header.times})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAA"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "times", (Object)3);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimesOverloadedBytesInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(byte[].class, ${header.times})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC,ABC,ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"ABC".getBytes(), "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimesOverloadedBytesIntLanguageTokens() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(byte[].class,${header.times})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC,ABC,ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"ABC".getBytes(), "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyBean {
        public String hello(String name) {
            return "Hello " + name;
        }

        public String hello(String name, String country) {
            return "Hello " + name + " you are from " + country;
        }

        public String times(String name, int times) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
            }
            return sb.toString();
        }

        public String times(byte[] data, int times) {
            String s = new String(data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(s);
                if (i >= times - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public String times(String name, int times, char separator) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
                if (i >= times - 1) continue;
                sb.append(separator);
            }
            return sb.toString();
        }
    }
}

