/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanOverloadedMethodFQNTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOrderNoFQN() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(MyOrder.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOrderNoFQNUnknown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(Unknown.class)")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)new MyOrder()), (String)"Should have thrown an exception");
        NoTypeConversionAvailableException cause = BeanOverloadedMethodFQNTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Unknown.class", (Object)cause.getValue());
    }

    @Test
    public void testOrderNoFQNBoolean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(MyOrder.class,Boolean.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK;GOLD"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOrderFQN() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$MyOrder.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOrderFQNUnknown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$Unknown.class)")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)new MyOrder()), (String)"Should have thrown an exception");
        NoTypeConversionAvailableException cause = BeanOverloadedMethodFQNTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$Unknown.class", (Object)cause.getValue());
    }

    @Test
    public void testOrderFQNBoolean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$MyOrder.class,Boolean.class)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK;GOLD"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyOrder {
    }

    public static final class MyBean {
        public String order(MyOrder order) {
            return "OK";
        }

        public String order(MyOrder order, Boolean gold) {
            return "OK;GOLD";
        }
    }
}

