/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanWithHeaderAnnotation;
import org.apache.camel.component.bean.ParameterBindingException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class BeanNoTypeConvertionPossibleWhenHeaderTest
extends ContextTestSupport {
    @Test
    public void testBeanHeaderNoTypeConvertionPossibleFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)555), (String)"Should have thrown an exception");
        ParameterBindingException pbe = BeanNoTypeConvertionPossibleWhenHeaderTest.assertIsInstanceOf(ParameterBindingException.class, e.getCause());
        Assertions.assertEquals((int)1, (int)pbe.getIndex());
        Assertions.assertTrue((boolean)pbe.getMethod().getName().contains("hello"));
        Assertions.assertEquals((Object)555, (Object)pbe.getParameterValue());
        NoTypeConversionAvailableException ntae = BeanNoTypeConvertionPossibleWhenHeaderTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
        Assertions.assertEquals(Integer.class, (Object)ntae.getFromType());
        Assertions.assertEquals(Document.class, (Object)ntae.getToType());
        Assertions.assertEquals((Object)555, (Object)ntae.getValue());
        Assertions.assertNotNull((Object)ntae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanHeaderNoTypeConvertionPossibleOK() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"<?xml version=\"1.0\"?><foo>bar</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanHeaderNoTypeConvertionPossibleOKNullHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)mock.message(0).header("foo")).isNull();
        this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", null);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanHeaderNoTypeConvertionPossibleOKNoHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)mock.message(0).header("foo")).isNull();
        this.template.requestBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(BeanWithHeaderAnnotation.class)).to("mock:result");
            }
        };
    }
}

