/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Date;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.OrderServiceBean;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class BeanNoTypeConvertionPossibleTest
extends ContextTestSupport {
    @Test
    public void testBeanNoTypeConvertionPossibleFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.requestBody("direct:start", (Object)new Date()), (String)"Should have thrown an exception");
        NoTypeConversionAvailableException ntae = BeanNoTypeConvertionPossibleTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
        Assertions.assertEquals(Date.class, (Object)ntae.getFromType());
        Assertions.assertEquals(Document.class, (Object)ntae.getToType());
        Assertions.assertNotNull((Object)ntae.getValue());
        Assertions.assertNotNull((Object)ntae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanNoTypeConvertionPossibleOK() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"77889,667,457"});
        this.template.requestBody("direct:start", (Object)"<foo>bar</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanNoTypeConvertionPossibleOKNullBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isNull();
        Object body = null;
        this.template.requestBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                OrderServiceBean bean = new OrderServiceBean();
                bean.setConverter(BeanNoTypeConvertionPossibleTest.this.context.getTypeConverter());
                ((RouteDefinition)this.from("direct:start").bean((Object)bean, "handleXML")).to("mock:result");
            }
        };
    }
}

