/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.BeanScope;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class BeanNoCacheTest
extends ContextTestSupport {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    @Test
    public void testBeanRefNoCache() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello1", "Bye2", "Camel3"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.template.sendBody("direct:start", (Object)"Bye");
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(MyCoolBean.class, "doSomething", BeanScope.Prototype)).to("mock:result");
            }
        };
    }

    public static class MyCoolBean {
        private final int count = COUNTER.incrementAndGet();

        public int getCount() {
            return this.count;
        }

        public String doSomething(String s) {
            return s + this.count;
        }
    }
}

