/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        jndi.bind("myOtherBean", (Object)new MyOtherBean());
        return jndi;
    }

    @Test
    public void testBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Camel"), (String)"Should have thrown exception");
        MethodNotFoundException cause = BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"doSomething()", (Object)cause.getMethodName());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOtherBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:other", (Object)"Camel"), (String)"Should have thrown exception");
        MethodNotFoundException cause = BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"doSomething()", (Object)cause.getMethodName());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething()")).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("bean:myOtherBean?method=doSomething()")).to("mock:result");
            }
        };
    }

    public static final class MyBean {
        public static void doSomething(Exchange exchange) {
            exchange.getIn().setHeader("foo", (Object)"bar");
        }
    }

    public static final class MyOtherBean {
        public static void doSomething(Exchange exchange) {
            exchange.getIn().setHeader("foo", (Object)"bar");
        }

        public static void doSomething(Exchange exchange, String foo, String bar) {
            exchange.getIn().setHeader(foo, (Object)bar);
        }
    }
}

