/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanMethodValueWithCommaTest
extends ContextTestSupport {
    @Test
    public void testSingle() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camela,b"});
        this.template.sendBody("direct:single", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDouble() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camelc,d"});
        this.template.sendBody("direct:double", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camele,f"});
        this.template.sendBodyAndHeader("direct:header", (Object)"Camel", "myHeader", (Object)"e,f");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void test() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"SomeID0 0 10,11,12 * * ?"});
        this.template.sendBody("direct:cron", (Object)new MyCronBody("SomeID", "0 0 10,11,12 * * ?"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:single").to("bean:foo?method=bar(${body}, 'a,b')")).to("mock:result");
                ((RouteDefinition)this.from("direct:double").to("bean:foo?method=bar(${body}, \"c,d\")")).to("mock:result");
                ((RouteDefinition)this.from("direct:header").to("bean:foo?method=bar(${body}, ${header.myHeader})")).to("mock:result");
                ((RouteDefinition)this.from("direct:cron").to("bean:foo?method=bar(${body.id}, ${body.cron})")).to("mock:result");
            }
        };
    }

    public static class MyCronBody {
        private final String id;
        private final String cron;

        public MyCronBody(String id, String cron) {
            this.id = id;
            this.cron = cron;
        }

        public String getId() {
            return this.id;
        }

        public String getCron() {
            return this.cron;
        }
    }

    public static class MyBean {
        public String bar(String body, String extra) {
            return body + extra;
        }
    }
}

