/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jndi.JndiBeanRepository;
import org.apache.camel.support.jndi.JndiContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanLookupUsingJndiRegistryIssueTest {
    @Test
    public void testCamelWithJndi() throws Exception {
        JndiContext jndi = new JndiContext();
        jndi.bind("foo", (Object)new MyOtherDummyBean());
        DefaultCamelContext camel = new DefaultCamelContext((Registry)new DefaultRegistry(new BeanRepository[]{new JndiBeanRepository((Context)jndi)}));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").bean((Object)"foo");
            }
        });
        camel.start();
        String reply = (String)camel.createProducerTemplate().requestBody("direct:start", (Object)"Camel", String.class);
        Assertions.assertEquals((Object)"Hello Camel", (Object)reply);
        camel.stop();
    }

    private static class MyOtherDummyBean {
        private MyOtherDummyBean() {
        }

        public String hello(String s) {
            return "Hello " + s;
        }
    }
}

