/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.BeanScope;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BeanLifecycleTest
extends ContextTestSupport {
    private MyBean statefulInstance;
    private MyBean statefulInstanceInRegistry;
    private MyBean statefulInstanceInRegistryNoCache;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.statefulInstance = new MyBean();
        this.statefulInstanceInRegistry = new MyBean();
        this.statefulInstanceInRegistryNoCache = new MyBean();
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        Assertions.assertEquals((Object)"stopped", (Object)this.statefulInstance.getStatus());
        Assertions.assertEquals((Object)"stopped", (Object)this.statefulInstanceInRegistry.getStatus());
        Assertions.assertNull((Object)this.statefulInstanceInRegistryNoCache.getStatus());
        Assertions.assertEquals((int)2, (int)MyStatefulBean.INSTANCES.get());
    }

    @Test
    public void testBeanLifecycle() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        Assertions.assertEquals((Object)"started", (Object)this.statefulInstance.getStatus());
        Assertions.assertEquals((Object)"started", (Object)this.statefulInstanceInRegistry.getStatus());
        Assertions.assertNull((Object)this.statefulInstanceInRegistryNoCache.getStatus());
        Assertions.assertEquals((int)2, (int)MyStatefulBean.INSTANCES.get());
        this.template.sendBody("direct:foo", null);
        mock.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("statefulInstanceInRegistry", (Object)this.statefulInstanceInRegistry);
        jndi.bind("statefulInstanceInRegistryNoCache", (Object)this.statefulInstanceInRegistryNoCache);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").bean((Object)BeanLifecycleTest.this.statefulInstance, "doSomething", BeanScope.Prototype)).bean(MyStatefulBean.class, "doSomething")).bean((Object)MyStatefulBean.class.getName(), "doSomething", BeanScope.Singleton)).bean((Object)MyStatelessBean.class.getName(), "doSomething", BeanScope.Prototype)).to("bean:statefulInstanceInRegistry?method=doSomething&scope=Singleton")).to("bean:statefulInstanceInRegistryNoCache?method=doSomething&scope=Prototype")).to("mock:result");
            }
        };
    }

    public static class MyBean
    implements Service {
        private String status;

        public String getStatus() {
            return this.status;
        }

        public void doSomething(Exchange exchange) {
        }

        public void start() {
            this.status = "started";
        }

        public void stop() {
            this.status = "stopped";
        }
    }

    public static class MyStatefulBean
    implements Service {
        private static final AtomicInteger INSTANCES = new AtomicInteger();

        public MyStatefulBean() {
            INSTANCES.incrementAndGet();
        }

        public void doSomething(Exchange exchange) {
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public static class MyStatelessBean
    implements Service {
        public void doSomething(Exchange exchange) {
        }

        public void start() {
            Assertions.fail((String)"Should not be invoked");
        }

        public void stop() {
            Assertions.fail((String)"Should not be invoked");
        }
    }
}

