/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanInvokeWithNullBodyTest
extends ContextTestSupport {
    @Test
    public void testWithHelloWorld() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithEmptyBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:start", (Object)"");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithNullBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyNullFooBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:foo")).to("mock:result");
            }
        };
    }

    private static class MyNullFooBean {
        private MyNullFooBean() {
        }

        public String doSomething(String s) {
            return s;
        }
    }
}

