/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MyStaticClass;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInvokeStaticTest
extends ContextTestSupport {
    @Test
    public void testA() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").bean(MyStaticClass.class, "changeSomething")).to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:a");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testB() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").bean(MyStaticClass.class, "doSomething")).to("mock:a");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        BeanInvokeStaticTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"Static method with name: doSomething not found on class: org.apache.camel.component.bean.MyStaticClass", (Object)e.getCause().getMessage());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

