/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInvokeAsyncTest
extends ContextTestSupport {
    private volatile CompletableFuture<Object> callFuture;
    private volatile String receivedBody;
    private volatile CountDownLatch methodInvoked;

    @Test
    public void testDoSomething() throws Exception {
        this.runTestSendBody("Hello World", "Hello World", this::doSomething);
        this.runTestSendBody("", "", this::doSomething);
        this.runTestSendBody(this::expectNullBody, null, this::doSomething);
    }

    @Test
    public void testChangeSomething() throws Exception {
        this.runTestSendBody("Bye World", "Hello World", this::changeSomething);
        this.runTestSendBody("Bye All", null, this::changeSomething);
        this.runTestSendBody("Bye All", "", this::changeSomething);
    }

    @Test
    public void testDoNothing() throws Exception {
        this.runTestSendBody("Hello World", "Hello World", this::doNothing);
        this.runTestSendBody("", "", this::doNothing);
        this.runTestSendBody(this::expectNullBody, null, this::doNothing);
    }

    @Test
    public void testThrowSomething() {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.runTestSendBody((MockEndpoint m) -> m.expectedMessageCount(0), "SomeProblem", this::throwSomething), (String)"Exception expected");
        boolean b1 = e.getCause() instanceof CamelExecutionException;
        Assertions.assertTrue((boolean)b1);
        boolean b = e.getCause().getCause() instanceof IllegalStateException;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"SomeProblem", (Object)e.getCause().getCause().getMessage());
    }

    private void runTestSendBody(String expectedBody, String sentBody, Function<String, String> processor) throws Exception {
        this.runTestSendBody((MockEndpoint m) -> m.expectedBodiesReceived(new Object[]{expectedBody}), sentBody, processor);
    }

    private void runTestSendBody(Consumer<MockEndpoint> mockPreparer, String sentBody, Function<String, String> processor) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mockPreparer.accept(mock);
        this.callFuture = new CompletableFuture();
        this.methodInvoked = new CountDownLatch(1);
        CompletableFuture sendFuture = this.template.asyncSendBody("direct:entry", (Object)sentBody);
        Assertions.assertTrue((boolean)this.methodInvoked.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)mock.getReceivedCounter());
        Assertions.assertFalse((boolean)sendFuture.isDone());
        try {
            this.callFuture.complete(processor.apply(this.receivedBody));
        }
        catch (Exception e) {
            this.callFuture.completeExceptionally(e);
        }
        sendFuture.get();
        this.assertMockEndpointsSatisfied();
    }

    private void expectNullBody(MockEndpoint mock) {
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isNull();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:entry").bean((Object)BeanInvokeAsyncTest.this, "asyncMethod")).to("mock:result");
            }
        };
    }

    public CompletableFuture<?> asyncMethod(String body) {
        this.receivedBody = body;
        this.methodInvoked.countDown();
        return this.callFuture;
    }

    public String doSomething(String s) {
        return s;
    }

    public String changeSomething(String s) {
        if ("Hello World".equals(s)) {
            return "Bye World";
        }
        return "Bye All";
    }

    public String doNothing(String s) {
        return null;
    }

    public String throwSomething(String s) {
        throw new IllegalStateException(s);
    }
}

