/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInfoWithBridgedMethodTest
extends ContextTestSupport {
    @Test
    public void testBridgedMethod() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, MyService.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request(1));
        Assertions.assertDoesNotThrow(() -> {
            MyService myService = new MyService();
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            Assertions.assertEquals((Object)"MyService", (Object)mi.getMethod().getDeclaringClass().getSimpleName());
            Assertions.assertEquals((Object)2, (Object)mi.getMethod().invoke((Object)myService, new Request(1)));
        }, (String)"This should not be ambiguous!");
    }

    @Test
    public void testPackagePrivate() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, MyPackagePrivateService.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request(1));
        Assertions.assertDoesNotThrow(() -> {
            MyPackagePrivateService myService = new MyPackagePrivateService();
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            Assertions.assertEquals((Object)"Service", (Object)mi.getMethod().getDeclaringClass().getSimpleName());
            Assertions.assertEquals((Object)4, (Object)mi.getMethod().invoke((Object)myService, new Request(2)));
        }, (String)"This should not be ambiguous!");
    }

    public static class MyService
    implements Service<Request> {
        @Override
        public int process(Request request) {
            return request.x + 1;
        }
    }

    public static class Request {
        final int x;

        public Request(int x) {
            this.x = x;
        }
    }

    static class MyPackagePrivateService
    implements Service<Request> {
        MyPackagePrivateService() {
        }

        @Override
        public int process(Request request) {
            return request.x + 2;
        }
    }

    public static interface Service<R> {
        public int process(R var1);
    }
}

