/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.InOnly;
import org.apache.camel.InOut;
import org.apache.camel.Pattern;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfoTest {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInfoTest.class);
    protected final CamelContext camelContext = new DefaultCamelContext();

    @Test
    public void testObjectOperations() {
        BeanInfo info = this.createBeanInfo(Object.class);
        List operations = info.getMethods();
        Assertions.assertEquals((int)1, (int)operations.size());
        Assertions.assertEquals((Object)"toString", (Object)((MethodInfo)operations.get(0)).getMethod().getName());
    }

    @Test
    public void testGetOperations() {
        BeanInfo info = this.createBeanInfo(Foo.class);
        List operations = info.getMethods();
        Assertions.assertEquals((int)2, (int)operations.size());
        long size = operations.stream().filter(m -> m.getMethod().getName().equals("inOnlyMethod")).count();
        Assertions.assertEquals((long)1L, (long)size);
        size = operations.stream().filter(m -> m.getMethod().getName().equals("inOutMethod")).count();
        Assertions.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testMethodPatternUsingMethodAnnotations() throws Exception {
        BeanInfo info = this.createBeanInfo(Foo.class);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    @Test
    public void testMethodPatternUsingClassAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(MyOneWayInterface.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    @Test
    public void testMethodPatternUsingMethodAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(MyOneWayInterfaceWithOverloadedMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
    }

    @Test
    public void testMethodPatternUsingClassAnnotationsButOverloadingOnMethod() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    @Test
    public void testMethodPatternUsingClassAnnotationsButOverloadingOnBaseClassMethod() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnBaseClass.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    @Test
    public void testMethodPatternUsingClassAnnotationsOnClassWithAnnotationsOnInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnMethod.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
    }

    @Test
    public void testMethodPatternUsingClassAnnotationsOnBaseInterfaceAndOverloadingMethodOnDerivedInterface() throws Exception {
        BeanInfo info = this.createBeanInfo(OverloadOnInterface.class);
        this.assertMethodPattern(info, "inOnlyMethod", ExchangePattern.InOnly);
        this.assertMethodPattern(info, "inOutMethod", ExchangePattern.InOut);
    }

    @Test
    public void testImplementLevel2InterfaceMethodInPackagePrivateClass() {
        BeanInfo info = this.createBeanInfo(PackagePrivateClassImplementingLevel2InterfaceMethod.class);
        List mis = info.getMethods();
        Assertions.assertNotNull((Object)mis);
        Assertions.assertEquals((int)1, (int)mis.size());
        MethodInfo mi = (MethodInfo)mis.get(0);
        Assertions.assertNotNull((Object)mi);
        Method m = mi.getMethod();
        Assertions.assertEquals((Object)"method", (Object)m.getName());
        Assertions.assertTrue((boolean)Modifier.isPublic(m.getDeclaringClass().getModifiers()));
    }

    @Test
    public void testPublicClassImplementingInterfaceMethodBySuperPackagePrivateClass() {
        BeanInfo info = this.createBeanInfo(PublicClassImplementingBySuperPackagePrivateClass.class);
        List mis = info.getMethods();
        Assertions.assertNotNull((Object)mis);
        Assertions.assertEquals((int)1, (int)mis.size());
        MethodInfo mi = (MethodInfo)mis.get(0);
        Assertions.assertNotNull((Object)mi);
        Method m = mi.getMethod();
        Assertions.assertEquals((Object)"method", (Object)m.getName());
        Assertions.assertTrue((boolean)Modifier.isPublic(m.getDeclaringClass().getModifiers()));
    }

    protected BeanInfo createBeanInfo(Class<?> type) {
        return new BeanInfo(this.camelContext, type);
    }

    protected void assertMethodPattern(BeanInfo info, String methodName, ExchangePattern expectedPattern) throws NoSuchMethodException {
        Class type = info.getType();
        Method method = type.getMethod(methodName, new Class[0]);
        Assertions.assertNotNull((Object)method, (String)("Could not find method: " + methodName));
        MethodInfo methodInfo = info.getMethodInfo(method);
        Assertions.assertNotNull((Object)methodInfo, (String)("Could not find methodInfo for: " + String.valueOf(method)));
        ExchangePattern actualPattern = methodInfo.getPattern();
        Assertions.assertEquals((Object)expectedPattern, (Object)actualPattern, (String)("Pattern for: " + String.valueOf(method)));
        LOG.info("Method: {} has pattern: {}", (Object)method, (Object)actualPattern);
    }

    public static interface Foo {
        public void inOutMethod();

        @Pattern(value=ExchangePattern.InOnly)
        public void inOnlyMethod();
    }

    @InOnly
    public static interface MyOneWayInterface {
        public void inOnlyMethod();
    }

    @InOnly
    public static interface MyOneWayInterfaceWithOverloadedMethod {
        public void inOnlyMethod();

        @InOut
        public Object inOutMethod();
    }

    public static class OverloadOnMethod
    implements MyOneWayInterface {
        @Override
        public void inOnlyMethod() {
        }
    }

    public static class OverloadOnBaseClass
    extends OverloadOnMethod {
        public void robustInOnlyMethod() {
        }
    }

    public static class OverloadOnInterface
    implements MyOneWayInterfaceWithOverloadedMethod {
        @Override
        public void inOnlyMethod() {
        }

        @Override
        public Object inOutMethod() {
            return null;
        }
    }

    static class PackagePrivateClassImplementingLevel2InterfaceMethod
    implements ILevel1Interface {
        PackagePrivateClassImplementingLevel2InterfaceMethod() {
        }

        @Override
        public String method() {
            return "PackagePrivateClassImplementingLevel2InterfaceMethod.method() has been called";
        }
    }

    public static class PublicClassImplementingBySuperPackagePrivateClass
    extends PackagePrivateClassDefiningMethod
    implements IMethodInterface {
    }

    static class PackagePrivateClassDefiningMethod {
        PackagePrivateClassDefiningMethod() {
        }

        public String method() {
            return "PackagePrivateClassDefiningMethod.method() has been called";
        }
    }

    public static interface IMethodInterface {
        public String method();
    }

    public static interface ILevel1Interface
    extends ILevel2Interface {
    }

    public static interface ILevel2Interface {
        public String method();
    }
}

