/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInfoSelectMethodTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testOrder() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Order"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailure() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Failure"});
        this.template.send("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello");
                exchange.setException((Throwable)new IllegalArgumentException("Forced by unit test"));
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").logStackTrace(false).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).bean((Object)"foo", "handleFailure")).to("mock:result");
                ((RouteDefinition)this.from("direct:a").bean((Object)"foo")).to("mock:result");
                this.from("direct:b").to("mock:foo");
            }
        };
    }

    public static class MyFooBean {
        public String handleException(Exception e) {
            Assertions.fail((String)"Should not call this method as it is not intended for Camel");
            return "Exception";
        }

        public String handleFailure(@Body String order, @ExchangeException IllegalArgumentException e) {
            return "Failure";
        }

        public String handleOrder(@Body String order) {
            return "Order";
        }
    }
}

