/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInfoInheritanceTest
extends ContextTestSupport {
    @Test
    public void testInheritance() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Y.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        Assertions.assertDoesNotThrow(() -> {
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            Assertions.assertNotNull((Object)mi);
            Assertions.assertEquals((Object)"process", (Object)mi.getMethod().getName());
            Assertions.assertEquals((Object)"Y", (Object)mi.getMethod().getDeclaringClass().getSimpleName());
        }, (String)"This should not be ambiguous!");
    }

    @Test
    public void testNoInheritance() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, A.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        Assertions.assertDoesNotThrow(() -> {
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            Assertions.assertNotNull((Object)mi);
            Assertions.assertEquals((Object)"process", (Object)mi.getMethod().getName());
            Assertions.assertEquals((Object)"A", (Object)mi.getMethod().getDeclaringClass().getSimpleName());
        }, (String)"This should not be ambiguous!");
    }

    @Test
    public void testInheritanceAndOverload() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Z.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        Assertions.assertThrows(AmbiguousMethodCallException.class, () -> beanInfo.createInvocation(null, (Exchange)exchange), (String)"This should be ambiguous!");
    }

    public static class Y
    extends X {
        @Override
        public int process(Request request) {
            return 1;
        }

        public int compute(String body) {
            return 2;
        }
    }

    public static class Request {
        int x;
    }

    public static class A {
        public void doSomething(String body) {
        }

        public int process(Request request) {
            return 0;
        }
    }

    public static class Z
    extends Y {
        public int compute(Request request) {
            return 2;
        }

        public int process(Request request, String body) {
            return 3;
        }
    }

    public static class X {
        public int process(Request request) {
            return 0;
        }
    }
}

