/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInfoAMoreComplexOverloadedTest
extends ContextTestSupport {
    @Test
    public void testRequestA() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage((CamelContext)this.context);
        message.setBody((Object)new RequestA());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        MethodInvocation methodInvocation = beanInfo.createInvocation((Object)new Bean(), (Exchange)exchange);
        Method method = methodInvocation.getMethod();
        Assertions.assertEquals((Object)"doSomething", (Object)method.getName());
        Assertions.assertEquals(RequestA.class, (Object)method.getGenericParameterTypes()[0]);
    }

    @Test
    public void testRequestB() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage((CamelContext)this.context);
        message.setBody((Object)new RequestB());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        MethodInvocation methodInvocation = beanInfo.createInvocation((Object)new Bean(), (Exchange)exchange);
        Method method = methodInvocation.getMethod();
        Assertions.assertEquals((Object)"doSomething", (Object)method.getName());
        Assertions.assertEquals(RequestB.class, (Object)method.getGenericParameterTypes()[0]);
    }

    @Test
    public void testAmbigious() {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage((CamelContext)this.context);
        message.setBody((Object)"Hello World");
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        AmbiguousMethodCallException e = (AmbiguousMethodCallException)Assertions.assertThrows(AmbiguousMethodCallException.class, () -> BeanInfoAMoreComplexOverloadedTest.lambda$testAmbigious$0(beanInfo, (Exchange)exchange), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)2, (int)e.getMethods().size());
    }

    private static /* synthetic */ void lambda$testAmbigious$0(BeanInfo beanInfo, Exchange exchange) throws Throwable {
        beanInfo.createInvocation((Object)new Bean(), exchange);
    }

    static class Bean {
        Bean() {
        }

        public void doSomething(RequestA request) {
        }

        public void doSomething(RequestB request) {
        }
    }

    static class RequestA
    extends BaseRequest {
        public int i;

        RequestA() {
        }
    }

    static class RequestB
    extends BaseRequest {
        public String s;

        RequestB() {
        }
    }

    static class BaseRequest {
        public long id;

        BaseRequest() {
        }
    }
}

