/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInPipelineTest
extends ContextTestSupport {
    @Test
    public void testBeanInPipeline() {
        Object response = this.template.requestBody("direct:start", (Object)"Start:");
        Assertions.assertEquals((Object)"Start:onetwothree", (Object)response);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("one", (Object)new MyBean("one"));
        answer.bind("two", (Object)new MyBean("two"));
        answer.bind("three", (Object)new MyBean("three"));
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").pipeline(new String[]{"bean:one", "bean:two", "log:x", "log:y", "bean:three"});
            }
        };
    }

    public static class MyBean {
        private final String postfix;

        public MyBean(String postfix) {
            this.postfix = postfix;
        }

        public String doSomething(String body) {
            return body + this.postfix;
        }
    }
}

