/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanHandlerMethodTest
extends ContextTestSupport {
    @Test
    public void testInterfaceBeanMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyConcreteBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyConcreteBean pojo = new MyConcreteBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNotNull((Object)mi);
        Assertions.assertEquals((Object)"hello", (Object)mi.getMethod().getName());
    }

    @Test
    public void testNoHandleMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyNoDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyNoDummyBean pojo = new MyNoDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNotNull((Object)mi);
        Assertions.assertEquals((Object)"hello", (Object)mi.getMethod().getName());
    }

    @Test
    public void testAmbigiousMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyAmbigiousBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyAmbigiousBean pojo = new MyAmbigiousBean();
        AmbiguousMethodCallException e = (AmbiguousMethodCallException)Assertions.assertThrows(AmbiguousMethodCallException.class, () -> BeanHandlerMethodTest.lambda$testAmbigiousMethod$0(info, pojo, (Exchange)exchange), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)2, (int)e.getMethods().size());
    }

    @Test
    public void testHandleMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyDummyBean pojo = new MyDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNotNull((Object)mi);
        Assertions.assertEquals((Object)"hello", (Object)mi.getMethod().getName());
    }

    @Test
    public void testHandleAndBodyMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyOtherDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyOtherDummyBean pojo = new MyOtherDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNotNull((Object)mi);
        Assertions.assertEquals((Object)"hello", (Object)mi.getMethod().getName());
    }

    @Test
    public void testHandleAmbigious() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyReallyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyReallyDummyBean pojo = new MyReallyDummyBean();
        AmbiguousMethodCallException e = (AmbiguousMethodCallException)Assertions.assertThrows(AmbiguousMethodCallException.class, () -> BeanHandlerMethodTest.lambda$testHandleAmbigious$1(info, pojo, (Exchange)exchange), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)2, (int)e.getMethods().size());
    }

    @Test
    public void testNoHandlerAmbigious() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyNoHandlerBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyNoHandlerBean pojo = new MyNoHandlerBean();
        AmbiguousMethodCallException e = (AmbiguousMethodCallException)Assertions.assertThrows(AmbiguousMethodCallException.class, () -> BeanHandlerMethodTest.lambda$testNoHandlerAmbigious$2(info, pojo, (Exchange)exchange), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)3, (int)e.getMethods().size());
    }

    private static /* synthetic */ void lambda$testNoHandlerAmbigious$2(BeanInfo info, MyNoHandlerBean pojo, Exchange exchange) throws Throwable {
        info.createInvocation((Object)pojo, exchange);
    }

    private static /* synthetic */ void lambda$testHandleAmbigious$1(BeanInfo info, MyReallyDummyBean pojo, Exchange exchange) throws Throwable {
        info.createInvocation((Object)pojo, exchange);
    }

    private static /* synthetic */ void lambda$testAmbigiousMethod$0(BeanInfo info, MyAmbigiousBean pojo, Exchange exchange) throws Throwable {
        info.createInvocation((Object)pojo, exchange);
    }

    public static class MyConcreteBean
    extends MyAbstractBean {
    }

    public static class MyNoDummyBean {
        public String hello(@Body String hi) {
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyAmbigiousBean {
        public String hello(String hi) {
            Assertions.fail((String)"Should not invoke me");
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyOtherDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        public String bye(@Body String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyReallyDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        @Handler
        public String bye(@Body String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyNoHandlerBean {
        public String hello(@Body String input, @Header(value="name") String name, @Header(value="age") int age) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }

        public String greeting(@Body String input, @Header(value="name") String name) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }

        public String bye(String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static abstract class MyAbstractBean
    implements MyBaseInterface {
        @Override
        public String hello(@Body String hi) {
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            Assertions.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static interface MyBaseInterface {
        @Handler
        public String hello(@Body String var1);
    }
}

