/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.io.ByteArrayInputStream;
import org.apache.camel.BeanScope;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.MyDummyBean;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanExplicitMethodAmbiguousTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("dummy", (Object)new MyDummyBean());
        return jndi;
    }

    @Test
    public void testBeanExplicitMethodAmbiguous() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.requestBody("direct:hello", (Object)"Camel"), (String)"Should thrown an exception");
        AmbiguousMethodCallException cause = BeanExplicitMethodAmbiguousTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
        Assertions.assertEquals((int)2, (int)cause.getMethods().size());
    }

    @Test
    public void testBeanExplicitMethodHandler() {
        String out = (String)this.template.requestBody("direct:bye", (Object)"Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)out);
    }

    @Test
    public void testBeanExplicitMethodInvocationStringBody() {
        String out = (String)this.template.requestBody("direct:foo", (Object)"Camel", String.class);
        Assertions.assertEquals((Object)"String", (Object)out);
    }

    @Test
    public void testBeanExplicitMethodInvocationInputStreamBody() {
        String out = (String)this.template.requestBody("direct:foo", (Object)new ByteArrayInputStream("Camel".getBytes()), String.class);
        Assertions.assertEquals((Object)"InputStream", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:hello").bean((Object)"dummy", "hello", BeanScope.Singleton);
                this.from("direct:bye").bean((Object)"dummy", BeanScope.Singleton);
                this.from("direct:foo").bean((Object)"dummy", "bar", BeanScope.Singleton);
            }
        };
    }
}

