/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanExcludedMethodTest
extends ContextTestSupport {
    @Test
    public void testExcludedMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyDummyBean pojo = new MyDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNull((Object)mi, (String)"Should not be possible to find a suitable method");
    }

    @Test
    public void testNotExcludedMethod() {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyOtherDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyOtherDummyBean pojo = new MyOtherDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        Assertions.assertNotNull((Object)mi);
        Assertions.assertEquals((Object)"hello", (Object)mi.getMethod().getName());
    }

    public static class MyDummyBean {
        public boolean equals(Object obj) {
            Assertions.fail((String)"Should not call equals");
            return true;
        }
    }

    public static class MyOtherDummyBean {
        public boolean equals(Object obj) {
            Assertions.fail((String)"Should not call equals");
            return true;
        }

        public String toString() {
            return "dummy";
        }

        public String hello(String hi) {
            return "Hello " + hi;
        }
    }
}

