/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanExchangeAsReturnTypeNotAllowedTest
extends ContextTestSupport {
    @Test
    public void testExchangeAsReturnTypeNotAllowed() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.sendBody("direct:in", (Object)"Hello World"), (String)"Should have thrown IllegalStateException");
        BeanExchangeAsReturnTypeNotAllowedTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        result.assertIsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:in").to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public Exchange doSomething(Exchange exchange) {
            return exchange;
        }
    }
}

