/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new FooBean());
        return jndi;
    }

    @Test
    public void testBeanEndpointCtr() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setEndpointUriIfNotSpecified("bean:foo");
        endpoint.setBeanName("foo");
        Assertions.assertEquals((Object)"foo", (Object)endpoint.getBeanName());
        Assertions.assertTrue((boolean)endpoint.isSingleton());
        Assertions.assertNull((Object)endpoint.getBeanHolder());
        Assertions.assertNull((Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"bean:foo", (Object)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    @Test
    public void testBeanEndpointCtrComponent() throws Exception {
        BeanComponent comp = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        final BeanEndpoint endpoint = new BeanEndpoint("bean:foo", (Component)comp);
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setBeanName("foo");
        Assertions.assertEquals((Object)"foo", (Object)endpoint.getBeanName());
        Assertions.assertTrue((boolean)endpoint.isSingleton());
        Assertions.assertNull((Object)endpoint.getBeanHolder());
        Assertions.assertNull((Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"bean:foo", (Object)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    @Test
    public void testBeanEndpointCtrComponentBeanProcessor() throws Exception {
        BeanComponent comp = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        RegistryBean holder = new RegistryBean((CamelContext)this.context, "foo", null, null);
        BeanProcessor bp = new BeanProcessor((BeanHolder)holder);
        final BeanEndpoint endpoint = new BeanEndpoint("bean:foo", (Component)comp, bp);
        endpoint.setBeanName("foo");
        Assertions.assertEquals((Object)"foo", (Object)endpoint.getBeanName());
        Assertions.assertTrue((boolean)endpoint.isSingleton());
        Assertions.assertNull((Object)endpoint.getBeanHolder());
        Assertions.assertNull((Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"bean:foo", (Object)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    @Test
    public void testBeanEndpointCtrWithMethod() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setBeanName("foo");
        endpoint.setMethod("hello");
        Assertions.assertEquals((Object)"foo", (Object)endpoint.getBeanName());
        Assertions.assertTrue((boolean)endpoint.isSingleton());
        Assertions.assertNull((Object)endpoint.getBeanHolder());
        Assertions.assertEquals((Object)"hello", (Object)endpoint.getMethod());
        Assertions.assertEquals((Object)"bean:foo?method=hello", (Object)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    public static class FooBean {
        public String hello(String hello) {
            return "Hello " + hello;
        }
    }
}

