/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanCreateBodyExceptionTest
extends ContextTestSupport {
    @Test
    public void testCreateBodyFirstTimeException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.send("direct:start", e -> e.setIn((Message)new DefaultMessage(e){
            private boolean created;

            protected Object createBody() {
                if (!this.created) {
                    this.created = true;
                    throw new IllegalArgumentException("Forced internal error");
                }
                return "Hello World";
            }
        }));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCreateBodyAlwaysException() {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.send("direct:start", e -> e.setIn((Message)new DefaultMessage(e){

            protected Object createBody() {
                throw new IllegalArgumentException("Forced internal error");
            }
        }));
        Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied());
        Assertions.assertEquals((int)1, (int)this.getMockEndpoint("mock:dead").getFailures().size());
        Throwable e2 = (Throwable)this.getMockEndpoint("mock:dead").getFailures().get(0);
        Assertions.assertNotNull((Object)e2);
        Assertions.assertEquals((Object)"Forced internal error", (Object)e2.getMessage());
    }

    @Test
    public void testProducerTemplateCreateBodyAlwaysException() {
        this.template.send("seda:empty", e -> e.setIn((Message)new DefaultMessage(e){

            protected Object createBody() {
                throw new IllegalArgumentException("Forced internal error");
            }
        }));
    }

    @Test
    public void testConsumerTemplateCreateBodyAlwaysException() {
        final AtomicBoolean fail = new AtomicBoolean();
        this.template.send("seda:empty", e -> e.setIn((Message)new DefaultMessage(e){

            protected Object createBody() {
                if (fail.get()) {
                    throw new IllegalArgumentException("Forced internal error");
                }
                return null;
            }

            public DefaultMessage newInstance() {
                return this;
            }
        }));
        fail.set(true);
        Exception e2 = (Exception)Assertions.assertThrows(Exception.class, () -> this.consumer.receiveBody("seda:empty", 1000L), (String)"Should throw exception");
        BeanCreateBodyExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e2);
        Assertions.assertEquals((Object)"Forced internal error", (Object)e2.getMessage());
        fail.set(false);
        Assertions.assertDoesNotThrow(() -> this.consumer.receiveBody("seda:empty", 1000L), (String)"");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead")).bean(BeanCreateBodyExceptionTest.class, "callMe")).to("mock:result");
            }
        };
    }

    public String callMe(String body) {
        return "Hello " + body;
    }
}

