/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanConcurrentTest
extends ContextTestSupport {
    @Test
    public void testBeanConcurrent() throws Exception {
        int i;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1000);
        mock.expectsNoDuplicates((Expression)BeanConcurrentTest.body());
        for (int i2 = 1000; i2 < 2000; ++i2) {
            this.template.sendBody("seda:foo", (Object)Integer.toString(i2));
        }
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < 1000; ++i) {
            String body = (String)((Exchange)mock.getReceivedExchanges().get(i)).getIn().getBody(String.class);
            list.add(body);
        }
        list.sort(null);
        Assertions.assertEquals((int)1000, (int)list.size());
        for (i = 1; i < 1000; ++i) {
            int num = 1000 + i;
            String s = num + " " + num;
            Assertions.assertEquals((Object)s, list.get(i));
        }
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo?concurrentConsumers=10").routeId("foo").autoStartup(false).to("bean:myBean")).to("mock:result");
            }
        };
    }

    private static class MyBean {
        private String foo;
        private String bar;
        private int baz;

        private MyBean() {
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public int getBaz() {
            return this.baz;
        }

        public void setBaz(int baz) {
            this.baz = baz;
        }

        public void doSomething() {
        }

        public String echo(String s) {
            return s + " " + s;
        }

        public String toString() {
            return "MyBean";
        }
    }
}

