/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MyContactBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanComponentMissingParenthesisTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyContactBean());
        return jndi;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCorrect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=concat(${body}, ${header.foo})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello=Camel"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMissing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=concat(${body}, ${header.foo}")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel"), (String)"Should throw exception");
        IllegalArgumentException iae = BeanComponentMissingParenthesisTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Method should end with parenthesis, was concat(${body}, ${header.foo}", (Object)iae.getMessage());
    }

    @Test
    public void testInvalidName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=--concat(${body}, ${header.foo})")).to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)"Camel"), (String)"Should throw exception");
        BeanComponentMissingParenthesisTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
    }

    public String doSomething(String body, String header) {
        return body + "=" + header;
    }
}

