/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.FooService;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanClassTypeUseBeanFromRegistryTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOneInstanceInRegistry() throws Exception {
        this.context.getRegistry().bind("foo", (Object)new MyFooBean());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(FooService.class)).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTwoInstancesInRegistry() throws Exception {
        this.context.getRegistry().bind("foo", (Object)new MyFooBean());
        this.context.getRegistry().bind("bar", (Object)new MyFooBean());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(FooService.class)).to("mock:result");
            }
        });
        FailedToCreateRouteException e = (FailedToCreateRouteException)Assertions.assertThrows(FailedToCreateRouteException.class, () -> this.context.start(), (String)"Should throw exception");
        BeanClassTypeUseBeanFromRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
    }

    @Test
    public void testZeroInstancesInRegistry() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(FooService.class)).to("mock:result");
            }
        });
        FailedToCreateRouteException e = (FailedToCreateRouteException)Assertions.assertThrows(FailedToCreateRouteException.class, () -> this.context.start(), (String)"Should throw exception");
        BeanClassTypeUseBeanFromRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
    }
}

