/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.OrderServiceBean;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanChoseMethodWithMatchingTypeAndSkipSettersTest
extends ContextTestSupport {
    private final OrderServiceBean service = new OrderServiceBean();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("orderService", (Object)this.service);
        return jndi;
    }

    @Test
    public void testSendCSVFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:queue:order");
        mock.expectedBodiesReceived(new Object[]{"66554,123,456"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"123,456", "CamelFileName", (Object)"66554.csv");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendXMLData() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:queue:order");
        mock.expectedBodiesReceived(new Object[]{"77889,667,457"});
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><order id=\"77889\"><customer id=\"667\"/><confirm>457</confirm></order>";
        this.template.sendBody("seda:xml", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                BeanChoseMethodWithMatchingTypeAndSkipSettersTest.this.service.setConverter(BeanChoseMethodWithMatchingTypeAndSkipSettersTest.this.context.getTypeConverter());
                ((RouteDefinition)this.from(BeanChoseMethodWithMatchingTypeAndSkipSettersTest.this.fileUri("?initialDelay=0&delay=10")).bean((Object)"orderService")).to("mock:queue:order");
                ((RouteDefinition)this.from("seda:xml").bean((Object)"orderService")).to("mock:queue:order");
            }
        };
    }
}

