/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bar;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.processor.RemoveHeaderProcessor;
import org.apache.camel.processor.SetHeaderProcessor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class BarSendDynamicAware
extends SendDynamicAwareSupport {
    private String scheme;

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean resolveRawParameterValues() {
        return true;
    }

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        String query = StringHelper.after((String)uri, (String)"?");
        if (query != null) {
            Map map = URISupport.parseQuery((String)query);
            return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, map, null);
        }
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        if (entry.getProperties().containsKey("drink")) {
            Object value = entry.getProperties().get("drink");
            return new SetHeaderProcessor(ExpressionBuilder.constantExpression((Object)"CamelBarDrink"), ExpressionBuilder.constantExpression(value));
        }
        return null;
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        return new RemoveHeaderProcessor("CamelBarDrink");
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        String uri = entry.getOriginalUri();
        return StringHelper.before((String)uri, (String)"?");
    }
}

