/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.impl.cluster.ClusteredRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusteredRoutePolicyLeaderChangeTest
extends ContextTestSupport {
    private ClusteredRoutePolicy policy;
    private TestClusterService cs;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.cs = new TestClusterService("my-cluster-service");
        context.addService((Object)this.cs);
        this.policy = ClusteredRoutePolicy.forNamespace((String)"my-ns");
        return context;
    }

    @Test
    public void testClusteredRoutePolicyOnLeadershipLost() {
        this.cs.getView().setLeader(true);
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.cs.getView().setLeader(false);
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("foo").routePolicy(new RoutePolicy[]{ClusteredRoutePolicyLeaderChangeTest.this.policy}).to("mock:foo");
            }
        };
    }

    private static class TestClusterService
    extends AbstractCamelClusterService<TestClusterView> {
        private TestClusterView view;

        public TestClusterService(String id) {
            super(id);
        }

        protected TestClusterView createView(String namespace) {
            if (this.view == null) {
                this.view = new TestClusterView((CamelClusterService)this, namespace);
            }
            return this.view;
        }

        public TestClusterView getView() {
            return this.view;
        }
    }

    private static class TestClusterView
    extends AbstractCamelClusterView {
        private boolean leader;
        private boolean running;

        public TestClusterView(CamelClusterService cluster, String namespace) {
            super(cluster, namespace);
        }

        public Optional<CamelClusterMember> getLeader() {
            return this.leader ? Optional.of(this.getLocalMember()) : Optional.empty();
        }

        public CamelClusterMember getLocalMember() {
            return new CamelClusterMember(){

                public boolean isLeader() {
                    return leader;
                }

                public boolean isLocal() {
                    return true;
                }

                public String getId() {
                    return this.getClusterService().getId();
                }
            };
        }

        public List<CamelClusterMember> getMembers() {
            return Collections.emptyList();
        }

        protected void doStart() {
            this.running = true;
        }

        protected void doStop() {
            this.running = false;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public void setLeader(boolean leader) {
            this.leader = leader;
            if (this.isRunAllowed()) {
                this.fireLeadershipChangedEvent(this.getLeader().orElse(null));
            }
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

