/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.cluster.ClusteredRoutePolicyFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusteredRoutePolicyFactoryTest
extends ContextTestSupport {
    private TestClusterService cs;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.cs = new TestClusterService("my-cluster-service");
        context.addService((Object)this.cs);
        ClusteredRoutePolicyFactory factory = ClusteredRoutePolicyFactory.forNamespace((String)"my-ns");
        context.addRoutePolicyFactory((RoutePolicyFactory)factory);
        return context;
    }

    @Test
    public void testClusteredRoutePolicyFactory() throws Exception {
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.cs.getView().setLeader(true);
        this.template.sendBody("seda:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    @Test
    public void testClusteredRoutePolicyFactoryAddRoute() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        });
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("bar"));
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.cs.getView().setLeader(true);
        this.template.sendBody("seda:foo", (Object)"Hello Foo");
        this.template.sendBody("seda:bar", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("bar"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("foo").to("mock:foo");
            }
        };
    }

    @Test
    public void testClusteredRoutePolicyFactoryAddRouteAlreadyLeader() throws Exception {
        this.cs.getView().setLeader(true);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        });
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("bar"));
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.template.sendBody("seda:foo", (Object)"Hello Foo");
        this.template.sendBody("seda:bar", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("bar"));
    }

    private static class TestClusterService
    extends AbstractCamelClusterService<TestClusterView> {
        private TestClusterView view;

        public TestClusterService(String id) {
            super(id);
        }

        protected TestClusterView createView(String namespace) {
            if (this.view == null) {
                this.view = new TestClusterView((CamelClusterService)this, namespace);
            }
            return this.view;
        }

        public TestClusterView getView() {
            return this.view;
        }
    }

    private static class TestClusterView
    extends AbstractCamelClusterView {
        private boolean leader;

        public TestClusterView(CamelClusterService cluster, String namespace) {
            super(cluster, namespace);
        }

        public Optional<CamelClusterMember> getLeader() {
            return this.leader ? Optional.of(this.getLocalMember()) : Optional.empty();
        }

        public CamelClusterMember getLocalMember() {
            return new CamelClusterMember(){

                public boolean isLeader() {
                    return leader;
                }

                public boolean isLocal() {
                    return true;
                }

                public String getId() {
                    return this.getClusterService().getId();
                }
            };
        }

        public List<CamelClusterMember> getMembers() {
            return Collections.emptyList();
        }

        public boolean isLeader() {
            return this.leader;
        }

        public void setLeader(boolean leader) {
            this.leader = leader;
            if (this.isRunAllowed()) {
                this.fireLeadershipChangedEvent(this.getLeader().orElse(null));
            }
        }
    }
}

